unit fSelPt;
// ptld/jit   3-31-07

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ExtCtrls, ORFn, ORNet;

type
  TfrmSelPt = class(TForm)
    pnlDirect: TPanel;
    lblPatient: TLabel;
    rgDirect: TRadioGroup;
    rbDir1: TRadioButton;
    rbDir2: TRadioButton;
    rbDir3: TRadioButton;
    rbDir4: TRadioButton;
    cbPatient: TORComboBox;
    btnDir1: TButton;
    btnDir2: TButton;
    lbDir: TListBox;
    pnlDemog: TORAutoPanel;
    Memo: TCaptionMemo;
    lblPtName: TStaticText;
    lblSSN: TStaticText;
    lblPtSSN: TStaticText;
    lblDOB: TStaticText;
    lblPtDOB: TStaticText;
    lblPtSex: TStaticText;
    lblPtVet: TStaticText;
    lblPtSC: TStaticText;
    lblLocation: TStaticText;
    lblPtRoomBed: TStaticText;
    lblPtLocation: TStaticText;
    lblRoomBed: TStaticText;
    btnPat: TButton;
    lblVet: TStaticText;
    cbDirSpec: TORComboBox;
    lblDirSpec: TLabel;
    pnlFlag: TPanel;
    procedure cbPatientClick(Sender: TObject);
    procedure btnDir1Click(Sender: TObject);
    procedure btnDir2Click(Sender: TObject);
    procedure cbPatientChange(Sender: TObject);
    procedure btnPatClick(Sender: TObject);
    procedure pnlFlagClick(Sender: TObject);
    procedure cbDirSpecClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSelPt: TfrmSelPt;

procedure DirectEntry;

implementation

{$R *.dfm}

uses SCMMain, fWait, fRequest, fSched, fPatInq, uORPtf, fPatientFlagMulti, fService,
     fFindCon, uCore, rLocal;

procedure DirectEntry;
var
  Z: string;
begin
  frmSelPt := TfrmSelPt.Create(Application);
  try
  with frmSelPt do
    begin
      Z := '';
      btnDir1.Visible := True;
      btnDir1.Enabled   := False;
      CallV('APTWL GET PATIENTS', ['A']);
      cbPatient.Items := RPCBrokerV.Results;
      CallV('APTWL GET SPEC', [0, Z, SiteIFN]);
      cbDirSpec.Items := RPCBrokerV.Results;
      ShowModal;
    end;
  finally
    frmSelPt.Release
  end;
end;

procedure TfrmSelPt.cbPatientClick(Sender: TObject);
var
  Result: string;
begin
  ResetTimeOut;
  Patient := TPatient.Create;
  if cbPatient.Text = '<More>' then
    begin
      CallV('APTWL GET PATIENTS', [piece(cbPatient.Items[(cbPatient.ItemIndex)-1], '^', 2)]);
      cbPatient.Items := RPCBrokerV.Results;
      Exit;
    end;
  DFN    := IntToStr(cbPatient.ItemIEN);
  Patient.DFN := DFN;
  PtName := piece(cbPatient.Items[cbPatient.ItemIndex], '^', 2);
  Result := sCallV('APTWL GET DEMOG', [DFN]);
  lblPtName.Caption := piece(Result, '^', 1);
  lblPtSSN.Caption  := piece(Result, '^', 2);
  lblPtDOB.Caption  := piece(Result, '^', 3);
  lblPtSex.Caption  := piece(Result, '^', 5) + ', ' + piece(Result, '^', 6);
  lblPtVet.Caption  := piece(Result, '^', 7);
  lblPtSC.Caption   := piece(Result, '^', 4);
  lblPtLocation.Caption := piece(Result, '^', 8);
  lblPtRoomBed.Caption  := piece(Result, '^', 9);
  pnlDemog.Visible  := True;
  btnPat.Visible    := True;
  btnDir1.Enabled   := True;
  HasFlag := False;
  FlagList := TStringList.Create;
  pnlFlag.Visible   := False;
  HasActiveFlg(FlagList, HasFlag, DFN);
  if HasFlag then pnlFlag.Visible := True;
end;

procedure TfrmSelPt.btnDir2Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmSelPt.btnDir1Click(Sender: TObject);
var
  I: integer;
begin
  if cbPatient.Text = '' then
    begin
      MessageDlg('Please select a patient.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if cbDirSpec.Text = '' then
    begin
      MessageDlg('Please select a specialty.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if (rbDir1.Checked = False) and (rbDir2.Checked = False) and (rbDir3.Checked = False) and (rbDir4.Checked = False) then
    begin
      MessageDlg('Please select one of the list types', mtwarning, [mbOK], 0);
      Exit;
    end;
  PCPConsult := 0;
  if ConMatch = 1 then
    begin
      FindConsult(SpecIFN);
      PCPConsult := StrToInt(frmFindCon.lbFSelect.Items[0]);
    end;
  lbDir.Clear;
  for I := 0 to 51 do lbDir.Items[I] := '';
  lbDir.Items[0]  := DFN + '^' + PtName + '^' + lblPtSSN.Caption;
  lbDir.Items[22] := '^^^^2';  // no procedure
  lbDir.Items[23] := IntToStr(SpecIFN) + '^' + SpecName + '^' + SpecAbbr + '^' + ColorToString(SpecColor);
  lbDir.Items[26] := '0';  // note IFN
  if rbDir1.Checked then
    begin
      Wait(lbDir.Items, 3, 'A');
    end;
  if rbDir2.Checked then
    begin
      Wait(lbDir.Items, 3, 'W');
    end;
  if rbDir3.Checked then
    begin
      Request(lbDir.Items, 3);
    end;
  if rbDir4.Checked then
    begin
      Schedule(0, lbDir.Items, 4);
    end;
  if PutFlag = 1 then Close;
end;

procedure TfrmSelPt.cbPatientChange(Sender: TObject);
begin
  if cbPatient.Text = '' then Exit;
  CallV('APTWL GET PATIENTS', [cbPatient.Text]);
  cbPatient.Items := RPCBrokerV.Results;
end;


procedure TfrmSelPt.btnPatClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmSelPt.pnlFlagClick(Sender: TObject);
begin
  ShowFlags(0);
end;

procedure TfrmSelPt.cbDirSpecClick(Sender: TObject);
var
  Data: string;
begin
  Data      := cbDirSpec.Items[cbDirSpec.ItemIndex];
  SpecIFN   := cbDirSpec.ItemIEN;
  SpecName  := piece(Data, '^', 2);
  SpecAbbr  := piece(Data, '^', 4);
  SSIFN     := 0;  // default
  if piece(data, '^', 5) <> '' then SSIFN := StrToInt(piece(Data, '^', 5));
  if (SSIFN = 0) then
    begin
      if MessageDlg('The ' + SpecName + ' specialty has no Service/Section definition.' + CRLF +
        'Please take care of that before using this specialty.', mtwarning, [mbOK, mbCancel], 0) = mrOK then
        begin
          GetService(cbDirSpec.Items);
          if frmService.btnExit.ModalResult = mrCancel then Exit;
        end
      else Exit;
    end;
  if piece(Data, '^', 7) <> '' then SpecColor := StringToColor(piece(Data, '^', 7));
end;

end.
